<?php
session_start();

// Jelszó ellenőrzés
$correct_password = 'Gemini12!';

// Ha a form be lett küldve jelszóval
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === $correct_password) {
        $_SESSION['authenticated'] = true;
    } else {
        $error_message = "Hibás jelszó!";
    }
}

// Ha nincs bejelentkezve, csak a login form-ot mutatjuk
if (!isset($_SESSION['authenticated'])) {
    ?>
    <!DOCTYPE html>
    <html lang="hu">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Helyettesítés Admin - Belépés</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #f0f0f0;
                display: flex;
                justify-content: center;
                align-items: center;
                height: 100vh;
                margin: 0;
            }
            .login-form {
                background: white;
                padding: 20px;
                border-radius: 8px;
                box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                width: 300px;
            }
            input {
                width: 100%;
                padding: 8px;
                margin: 10px 0;
                border: 1px solid #ddd;
                border-radius: 4px;
                box-sizing: border-box;
            }
            button {
                width: 100%;
                padding: 10px;
                background: #4CAF50;
                color: white;
                border: none;
                border-radius: 4px;
                cursor: pointer;
            }
            button:hover {
                background: #45a049;
            }
            .error {
                color: red;
                margin-bottom: 10px;
            }
        </style>
    </head>
    <body>
        <div class="login-form">
            <h2>Helyettesítés Admin</h2>
            <?php if (isset($error_message)): ?>
                <div class="error"><?php echo $error_message; ?></div>
            <?php endif; ?>
            <form method="POST">
                <input type="password" name="password" placeholder="Jelszó" required>
                <button type="submit">Belépés</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit();
}

// Adatbázis kapcsolat
require_once 'config.php';

$db = new mysqli(DB_HOST, DB_USER, DB_PASS, 'terem');
if ($db->connect_error) {
    die("Kapcsolódási hiba: " . $db->connect_error);
}
$db->set_charset("utf8mb4");

// Csengetési rend módosítása
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['normal_csengetesi_rend'])) {
        $sql_commands = [
            "UPDATE orarend SET kezdes = '08:10', vege = '08:55' WHERE ora_sorszam = 1",
            "UPDATE orarend SET kezdes = '09:05', vege = '09:50' WHERE ora_sorszam = 2",
            "UPDATE orarend SET kezdes = '10:05', vege = '10:50' WHERE ora_sorszam = 3",
            "UPDATE orarend SET kezdes = '11:00', vege = '11:45' WHERE ora_sorszam = 4",
            "UPDATE orarend SET kezdes = '11:55', vege = '12:40' WHERE ora_sorszam = 5",
            "UPDATE orarend SET kezdes = '13:00', vege = '13:45' WHERE ora_sorszam = 6",
            "UPDATE orarend SET kezdes = '13:55', vege = '14:40' WHERE ora_sorszam = 7",
            "UPDATE orarend SET kezdes = '14:45', vege = '15:30' WHERE ora_sorszam = 8"
        ];

        $success = true;
        foreach ($sql_commands as $sql) {
            if (!$db->query($sql)) {
                $success = false;
                break;
            }
        }

        if ($success) {
            $success_message = "Normál csengetési rend beállítva!";
        } else {
            $error_message = "Hiba történt a csengetési rend módosításakor!";
        }
    }

    if (isset($_POST['rovid_csengetesi_rend'])) {
        $sql_commands = [
            "UPDATE orarend SET kezdes = '08:10', vege = '08:50' WHERE ora_sorszam = 1",
            "UPDATE orarend SET kezdes = '09:00', vege = '09:40' WHERE ora_sorszam = 2",
            "UPDATE orarend SET kezdes = '09:50', vege = '10:30' WHERE ora_sorszam = 3",
            "UPDATE orarend SET kezdes = '10:40', vege = '11:20' WHERE ora_sorszam = 4",
            "UPDATE orarend SET kezdes = '11:30', vege = '12:10' WHERE ora_sorszam = 5",
            "UPDATE orarend SET kezdes = '12:20', vege = '13:00' WHERE ora_sorszam = 6",
            "UPDATE orarend SET kezdes = '13:10', vege = '13:50' WHERE ora_sorszam = 7",
            "UPDATE orarend SET kezdes = '14:00', vege = '14:40' WHERE ora_sorszam = 8"
        ];

        $success = true;
        foreach ($sql_commands as $sql) {
            if (!$db->query($sql)) {
                $success = false;
                break;
            }
        }

        if ($success) {
            $success_message = "Rövidített csengetési rend beállítva!";
        } else {
            $error_message = "Hiba történt a csengetési rend módosításakor!";
        }
    }
}

// Helyettesítés hozzáadása
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_helyettesites'])) {
    $stmt = $db->prepare("INSERT INTO helyettesitesek (
        datum,
        ora_sorszam,
        osztaly,
        tantargy,
        hianyzo_tanar,
        terem,
        jelleg,
        helyettesito_tanar
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param("ssssssss",
        $_POST['datum'],
        $_POST['ora_sorszam'],
        $_POST['osztaly'],
        $_POST['tantargy'],
        $_POST['hianyzo_tanar'],
        $_POST['terem'],
        $_POST['jelleg'],
        $_POST['helyettesito_tanar']
    );

    if ($stmt->execute()) {
        $success_message = "Helyettesítés sikeresen rögzítve!";
    } else {
        $error_message = "Hiba történt: " . $stmt->error;
    }
    $stmt->close();
}

// Kijelentkezés kezelése
if (isset($_POST['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit();
}
?>
<!DOCTYPE html>
<html lang="hu">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Helyettesítés Admin</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            background-color: #f0f0f0;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            color: white;
        }
        button:hover {
            opacity: 0.9;
        }
        .message {
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .success {
            background-color: #dff0d8;
            color: #3c763d;
            border: 1px solid #d6e9c6;
        }
        .error {
            background-color: #f2dede;
            color: #a94442;
            border: 1px solid #ebccd1;
        }
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        .logout-form {
            text-align: right;
            margin-bottom: 20px;
        }
        .logout-button {
            background: #f44336;
        }
        .logout-button:hover {
            background: #da190b;
        }
        .csengetesi-rend-form {
            margin: 20px 0;
            display: flex;
            gap: 10px;
            justify-content: center;
        }
        .normal-button {
            background: #4CAF50;
        }
        .normal-button:hover {
            background: #45a049;
        }
        .rovid-button {
            background: #ff9800;
        }
        .rovid-button:hover {
            background: #f57c00;
        }
        .submit-button {
            background: #4CAF50;
            width: 100%;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <form method="POST" class="logout-form">
            <button type="submit" name="logout" class="logout-button">Kijelentkezés</button>
        </form>

        <h2>Csengetési rend módosítása</h2>
        <form method="POST" class="csengetesi-rend-form">
            <button type="submit" name="normal_csengetesi_rend" class="normal-button">Normál csengetési rend</button>
            <button type="submit" name="rovid_csengetesi_rend" class="rovid-button">Rövidített csengetési rend</button>
        </form>
    </div>

    <div class="container">
        <h2>Helyettesítés Felvitele</h2>
        
        <?php if (isset($success_message)): ?>
            <div class="message success"><?php echo $success_message; ?></div>
        <?php endif; ?>

        <?php if (isset($error_message)): ?>
            <div class="message error"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="grid">
                <div class="form-group">
                    <label>Dátum</label>
                    <input type="date" name="datum" value="<?php echo date('Y-m-d'); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Óra sorszáma</label>
                    <input type="text" name="ora_sorszam" placeholder="pl.: 4." required>
                </div>

                <div class="form-group">
                    <label>Helyettesítő tanár</label>
                    <input type="text" name="helyettesito_tanar" required>
                </div>

                <div class="form-group">
                    <label>Hiányzó tanár</label>
                    <input type="text" name="hianyzo_tanar" required>
                </div>

                <div class="form-group">
                    <label>Tantárgy</label>
                    <input type="text" name="tantargy" required>
                </div>

                <div class="form-group">
                    <label>Osztály</label>
                    <input type="text" name="osztaly" required>
                </div>

                <div class="form-group">
                    <label>Terem</label>
                    <input type="text" name="terem" required>
                </div>

                <div class="form-group">
                    <label>Jelleg</label>
                    <input type="text" name="jelleg" required>
                </div>
            </div>

            <button type="submit" name="submit_helyettesites" class="submit-button">Helyettesítés Mentése</button>
        </form>
    </div>
</body>
</html>
<?php
$db->close();
?>