<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'config.php';

$db = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($db->connect_error) {
    die("Kapcsolódási hiba: " . $db->connect_error);
}
$db->set_charset("utf8mb4");

function getHelyettesitesek($url = HELYETTESITESEK_URL) {
    echo "URL lekérdezése: $url<br>";
    $html = file_get_contents($url);
    if ($html === false) {
        echo "Hiba: Nem sikerült lekérni a HTML tartalmat.<br>";
        return false;
    }
    echo "HTML tartalom hossza: " . strlen($html) . " karakter<br>";

    $dom = new DOMDocument();
    @$dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));
    $xpath = new DOMXPath($dom);
    
    $helyettesitesek = [];
    $rows = $xpath->query("//table[@class='helyettesitesek']/tbody/tr[@class='órarend' or @class='plusz']");
    
    echo "Talált sorok száma: " . $rows->length . "<br>";

    if ($rows->length > 0) {
        foreach ($rows as $index => $row) {
            $cells = $row->getElementsByTagName('td');
              $helyettesites = [
                    'ora' => trim($cells->item(0)->textContent),
                    'osztaly' => trim($osztaly),
                    'tantargy' => trim($tantargy),
                    'hianyzo' => trim($cells->item(2)->textContent),
                    'terem' => trim($cells->item(3)->textContent),
                    'jelleg' => trim($cells->item(4)->textContent),
                    'helyettesito' => $cells->item(5) ? trim($cells->item(5)->textContent) : '-'
                ];

            // Osztály és tantárgy kezelése
            if ($cells->item(1) && $cells->item(1)->hasAttribute('colspan') && $cells->item(1)->getAttribute('colspan') == '2') {
                $osztaly_tantargy = trim($cells->item(1)->textContent);
                $osztaly_tantargy_parts = explode(' ', $osztaly_tantargy, 2);
                $helyettesites['osztaly'] = $osztaly_tantargy_parts[0];
                $helyettesites['tantargy'] = isset($osztaly_tantargy_parts[1]) ? $osztaly_tantargy_parts[1] : '-';
            } else {
                $helyettesites['osztaly'] = $cells->item(1) ? trim($cells->item(1)->textContent) : '-';
                $helyettesites['tantargy'] = $cells->item(2) ? trim($cells->item(2)->textContent) : '-';
            }

            // Üres értékek helyettesítése '-' karakterrel
            foreach ($helyettesites as $key => $value) {
                if (empty($value) || $value == '&nbsp;') {
                    $helyettesites[$key] = '-';
                }
            }

            $helyettesitesek[] = $helyettesites;
            echo "Feldolgozott sor: " . implode(', ', $helyettesites) . "<br>";
        }
    } else {
        echo "Figyelmeztetés: Nem található helyettesítési adat a táblázatban.<br>";
    }
    
    echo "Feldolgozott helyettesítések száma: " . count($helyettesitesek) . "<br>";

    // Utolsó frissítés időpontja
    $frissites_idopont_node = $xpath->query("//table[@class='helyettesitesek']/tfoot/tr/th")->item(0);
    $frissites_idopont = $frissites_idopont_node ? $frissites_idopont_node->nodeValue : 'Nem található';
    echo "Frissítés időpontja: $frissites_idopont<br>";

    return [
        'helyettesitesek' => $helyettesitesek,
        'frissites_idopont' => $frissites_idopont
    ];
}

function tarolHelyettesitesek($helyettesitesek, $frissites_idopont) {
    global $db;
    
    // Töröljük a régi helyettesítéseket
    $db->query("TRUNCATE TABLE helyettesitesek");
    echo "Régi helyettesítések törölve.<br>";

    if (empty($helyettesitesek)) {
        echo "Figyelmeztetés: Nincsenek helyettesítések a tároláshoz.<br>";
        return;
    }

    // Új helyettesítések beszúrása
    $stmt = $db->prepare("INSERT INTO helyettesitesek (datum, ora_sorszam, osztaly, tantargy, hianyzo_tanar, terem, jelleg, helyettesito_tanar, frissites_idopont) VALUES (CURDATE(), ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $inserted_count = 0;
    foreach ($helyettesitesek as $h) {
        $stmt->bind_param("ssssssss", 
            $h['ora'], 
            $h['osztaly'], 
            $h['tantargy'], 
            $h['hianyzo'], 
            $h['terem'], 
            $h['jelleg'],
            $h['helyettesito'],
            $frissites_idopont
        );
        if ($stmt->execute()) {
            $inserted_count++;
        } else {
            echo "Hiba a beszúrás során: " . $stmt->error . "<br>";
        }
    }
    
    $stmt->close();
    echo "Sikeresen beszúrt helyettesítések száma: $inserted_count<br>";
}

// Helyettesítések lekérdezése és tárolása
$helyettesitesek_adat = getHelyettesitesek();
if ($helyettesitesek_adat !== false) {
    tarolHelyettesitesek($helyettesitesek_adat['helyettesitesek'], $helyettesitesek_adat['frissites_idopont']);
    echo "Helyettesítések feldolgozása befejezve.";
} else {
    echo "Hiba történt a helyettesítések lekérdezése során.";
}

$db->close();
?>