<?php
session_start();

$db_config = [
    'host' => 'localhost',
    'user' => 'kanizsay',
    'pass' => 'Gemini12!',
    'db'   => 'terem'
];

$page_password = '3965824fGh!';

if (isset($_POST['password'])) {
    if ($_POST['password'] === $page_password) {
        $_SESSION['logged_in'] = true;
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

if (isset($_POST['execute_sql']) && isset($_SESSION['logged_in'])) {
    $sql = $_POST['generated_sql'];
    try {
        $pdo = new PDO(
            "mysql:host={$db_config['host']};dbname={$db_config['db']};charset=utf8mb4",
            $db_config['user'],
            $db_config['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        $pdo->beginTransaction();
        $statements = explode(';', $sql);
        foreach($statements as $statement) {
            if (trim($statement) != '') {
                $pdo->exec($statement);
            }
        }
        $pdo->commit();
        $message = "SQL sikeresen végrehajtva!";
    } catch (PDOException $e) {
        if (isset($pdo)) {
            $pdo->rollBack();
        }
        $error = "Adatbázis hiba: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="hu">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Órarend Feldolgozó</title>
    <link href="https://cdn.jsdelivr.net/npm/@tailwindcss/forms@0.5.3/dist/forms.min.css" rel="stylesheet">
    <link href="https://unpkg.com/tailwindcss@^2/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100 min-h-screen">
<?php if (!isset($_SESSION['logged_in'])): ?>
    <div class="flex items-center justify-center min-h-screen">
        <form method="post" class="bg-white p-8 rounded-lg shadow-md w-96">
            <h2 class="text-2xl font-bold mb-6 text-center">Órarend Feldolgozó</h2>
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">Jelszó:</label>
                <input type="password" name="password" required 
                       class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
            </div>
            <button type="submit" 
                    class="w-full bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                Belépés
            </button>
        </form>
    </div>
<?php else: ?>
    <div class="container mx-auto px-4 py-8">
        <div class="flex justify-between items-center mb-8">
            <h1 class="text-3xl font-bold">Órarend Feldolgozó</h1>
            <a href="?logout=1" class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                Kijelentkezés
            </a>
        </div>

        <div class="bg-white p-6 rounded-lg shadow-md mb-8">
            <form id="timetableForm" method="post" class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Terem ID:</label>
                        <input type="text" name="room_id" required
                               class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    </div>
                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Terem név:</label>
                        <input type="text" name="room_name" required
                               class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    </div>
                    <div>
                        <label class="block text-gray-700 text-sm font-bold mb-2">Hét típusa:</label>
                        <select name="week_type" required
                                class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                            <option value="null">Nincs páros-páratlan hét</option>
                            <option value="0">Páros hét</option>
                            <option value="1">Páratlan hét</option>
                        </select>
                    </div>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">HTML kód beillesztése:</label>
                    <textarea id="htmlInput" 
                              class="w-full h-64 p-2 border rounded font-mono text-sm"
                              placeholder="Másold ide a HTML táblázatot..."></textarea>
                </div>

                <div class="flex space-x-4">
                    <button type="button" onclick="parseHTML()"
                            class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                        HTML feldolgozása
                    </button>
                    <input type="hidden" name="generated_sql" id="generated_sql">
                    <button type="submit" name="execute_sql" id="executeButton" disabled
                            class="bg-green-500 hover:bg-green-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline opacity-50">
                        SQL végrehajtása
                    </button>
                </div>
            </form>
        </div>

        <div class="bg-white p-6 rounded-lg shadow-md">
            <h2 class="text-xl font-bold mb-4">Generált SQL</h2>
            <textarea id="sqlOutput" readonly
                      class="w-full h-64 p-2 border rounded font-mono text-sm"></textarea>
        </div>

        <?php if (isset($message)): ?>
            <div class="mt-4 p-4 bg-green-100 text-green-700 rounded">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
            <div class="mt-4 p-4 bg-red-100 text-red-700 rounded">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
    </div>

    <script>
        const timeSlots = [
            ['0', '07:15', '08:00'],
            ['1', '08:10', '08:55'],
            ['2', '09:05', '09:50'],
            ['3', '10:05', '10:50'],
            ['4', '11:00', '11:45'],
            ['5', '11:55', '12:40'],
            ['6', '13:00', '13:45'],
            ['7', '13:55', '14:40'],
            ['8', '14:45', '15:30'],
            ['9', '15:40', '16:25'],
            ['10', '16:35', '17:20'],
            ['11', '17:30', '18:25']
        ];

        function extractLessonInfo(cellDiv) {
            const result = {
                className: null,
                subject: null,
                teacher: null
            };

            if (!cellDiv) return result;

            // Az első span tartalmazza az osztály és tantárgy információt
            const firstSpan = cellDiv.querySelector('span');
            if (firstSpan) {
                const fullText = firstSpan.textContent.trim();
                const firstSpace = fullText.indexOf(' ');
                if (firstSpace !== -1) {
                    result.className = fullText.substring(0, firstSpace);
                    result.subject = fullText.substring(firstSpace + 1);
                }
            }

            // A tanár neve a <br> után van
            const html = cellDiv.innerHTML;
            const parts = html.split('<br>');
            if (parts.length > 1) {
                result.teacher = parts[1].replace(/[○\s]/g, '').trim();
            }

            return result;
        }

        function parseHTML() {
            const htmlInput = document.getElementById('htmlInput').value;
            const roomId = document.querySelector('input[name="room_id"]').value;
            const roomName = document.querySelector('input[name="room_name"]').value;
            const weekType = document.querySelector('select[name="week_type"]').value;

            if (!htmlInput || !roomId || !roomName) {
                alert('Kérlek töltsd ki az összes mezőt és illeszd be a HTML kódot!');
                return;
            }

            try {
                const parser = new DOMParser();
                const doc = parser.parseFromString(htmlInput, 'text/html');

                let sql = `-- Először beszúrjuk a termet, ha még nem létezik
INSERT IGNORE INTO termek (id, nev) VALUES ('${roomId}', '${roomName}');

-- Töröljük a régi adatokat
DELETE FROM orarend WHERE terem_id = '${roomId}';

-- Most importáljuk az órarendet
INSERT INTO orarend (terem_id, nap, ora_sorszam, kezdes, vege, tantargy, tanar, osztaly, het) VALUES\n`;

                const values = [];

                for (let day = 1; day <= 5; day++) {
                    for (const [slot, start, end] of timeSlots) {
                        const cell = doc.querySelector(`td[data-napindex="${day}"][data-oraindex="${slot}"]`);
                        let lessonInfo = { className: null, subject: null, teacher: null };
                        
                        if (cell) {
                            const contentDiv = cell.querySelector('div');
                            if (contentDiv) {
                                lessonInfo = extractLessonInfo(contentDiv);
                            }
                        }

                        values.push(
                            `('${roomId}', ${day}, ${slot}, '${start}', '${end}', ` +
                            `${lessonInfo.subject ? `'${lessonInfo.subject}'` : 'NULL'}, ` +
                            `${lessonInfo.teacher ? `'${lessonInfo.teacher}'` : 'NULL'}, ` +
                            `${lessonInfo.className ? `'${lessonInfo.className}'` : 'NULL'}, ` +
                            `${weekType === 'null' ? 'NULL' : weekType})`
                        );
                    }
                }

                sql += values.join(',\n') + ';';

                document.getElementById('sqlOutput').value = sql;
                document.getElementById('generated_sql').value = sql;
                document.getElementById('executeButton').disabled = false;
                document.getElementById('executeButton').classList.remove('opacity-50');

                alert('HTML feldolgozása sikeres! Az SQL kód legenerálva.');

            } catch (error) {
                console.error(error);
                alert('Hiba történt a HTML feldolgozása során: ' + error.message);
            }
        }
    </script>
<?php endif; ?>
</body>
</html>